//
// oled test program
// Written by Larry Bank
#include <stdint.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <stdbool.h>
#include <unistd.h>
#include "oled96.h"

int main(int argc, char *argv[])
{
	bool b_clean = false, b_exit = false;
	int i_line = -1, i;
	uint8_t u_contrast = 0, u_row = 0, u_pos = 0;
	char message[32] = "";

	if (argc > 1)
	{
		for (int ar = 1; ar < argc; ar++)
		{
			if ((strcmp(argv[ar], "--clean") == 0) || (strcmp(argv[ar], "-c") == 0))
				b_clean = true;
			if ((strcmp(argv[ar], "--exit") == 0) || (strcmp(argv[ar], "-e") == 0))
				b_exit = true;
			if ((strcmp(argv[ar], "--contrast") == 0) || (strcmp(argv[ar], "-t") == 0))
			{
				if (argc > ar+1)
					u_contrast = atoi(argv[ar+1]);
			}
			if ((strcmp(argv[ar], "--row") == 0) || (strcmp(argv[ar], "-r") == 0))
			{
				if (argc > ar+1)
					u_row = atoi(argv[ar+1])&0x07;
			}
			if ((strcmp(argv[ar], "--position") == 0) || (strcmp(argv[ar], "-p") == 0))
			{
				if (argc > ar+1)
					u_pos = atoi(argv[ar+1])&0x0f;
			}
			if ((strcmp(argv[ar], "--message") == 0) || (strcmp(argv[ar], "-m") == 0))
			{
				if (argc > ar+1)
					sprintf(message, "%s", argv[ar+1]);
			}
			if ((strcmp(argv[ar], "--line") == 0) || (strcmp(argv[ar], "-l") == 0))
			{
				if (argc > ar+1)
					i_line = atoi(argv[ar+1])&0x0f3f;
			}
			
			if ((strcmp(argv[ar], "--help") == 0) || (strcmp(argv[ar], "-h") == 0))
			{
				printf("\nPrint OLED.\n\n");
				printf("\t -c\t --clean        vymazani plochy.\n");
				printf("\t -e\t --exit         ukonceni komunikace OLED.\n");
				printf("\t -t\t --contrast     nastaveni kontrastu (0 - 255).\n");
				printf("\t -r\t --row          radka pro zapis (0 - 7).\n");
				printf("\t -p\t --position     odsazeni textu (0 - 15).\n");
				printf("\t -m\t --message      text pro zapis.\n");
				printf("\t -l\t --line         vykresli linku pozici (0 - 63) SIZE (1 - 15).\n");
				printf("\t -h\t --help         vypise tuto napovedu.\n\n");
				exit(EXIT_SUCCESS);
			}

		}
	}

	i = oledInit(1, 0x3c); // for Raspberry Pi, use channel 1
	if (i == 0)
	{
		if (b_clean)
			oledFill(0);
		oledSetContrast(u_contrast);	
		if (strlen(message) > 0)
		{
			oledWriteString(u_pos, u_row, message, 0);
		}

		if (i_line >= 0)
		{
			for (int l=2; l<127; l++)
			{
				oledSetPixel(l, i_line&0xff, 1);
				if (i_line&0xf00)
				{
					for (int sz=1; sz<(i_line>>8); sz++)
						oledSetPixel(l, (i_line&0xff)+sz, 1);
				}
			}
		}
		if (b_exit)
			oledShutdown();
	}
   return 0;
} /* main() */
